# -*- coding: cp1252 -*-
overrideIcon= ""

######################################################################
#
# Name:  Copy a file or folder to clients
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This tool creates a batch file that executes a copy command.
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################

import os
import datetime

OSname=""
if (sys.platform.lower() == "win32"):
    OSname="Windows"
elif (sys.platform.lower() == "darwin"):
    OSname="OSX"
else:
    OSname="Linux"
    

myUI= rrGlobal.getGenericUI()
myUI.addItem(rrGlobal.genUIType.label,"infoLabel","")
myUI.setText("infoLabel","\nEach assigned client executes this copy command.\nPlease set either a source and target filename OR folder.\n\nNote: This job will work on your OS only ("+OSname+"). This script pre-selects these clients for you.\n\n")
myUI.addItem(rrGlobal.genUIType.label,"labelMode","")
myUI.setText("labelMode","Copy Modes:")
myUI.addItem(rrGlobal.genUIType.dropdown,"dropMode","")
myUI.addText("dropMode","Do not overwrite.");
myUI.addText("dropMode","Overwrite if different   (size/time)");
myUI.addText("dropMode","Sync mode (Folders only. Delete files in target if not existing in source)");
myUI.addText("dropMode","Overwrite all");
myUI.addText("dropMode","Overwrite all, rename existing target files in case they are in use.");


myUI.addItem(rrGlobal.genUIType.spacerV,"spacerF","")
myUI.addItem(rrGlobal.genUIType.label,"labelDivideF","")
myUI.setText("labelDivideF","_________________________________________________________")
myUI.addItem(rrGlobal.genUIType.label,"labelCopyF","")
myUI.setText("labelCopyF","Source File:")
myUI.addItem(rrGlobal.genUIType.browseFile,"copySourceF","")
myUI.addItem(rrGlobal.genUIType.label,"labelCopyF2","")
myUI.setText("labelCopyF2","Target File:")
myUI.addItem(rrGlobal.genUIType.browseFile,"copyTargetF","")


myUI.addItem(rrGlobal.genUIType.spacerV,"spacerD","")
myUI.addItem(rrGlobal.genUIType.label,"labelDivideD","")
myUI.setText("labelDivideD","_________________________________________________________")
myUI.addItem(rrGlobal.genUIType.label,"labelCopyD","")
myUI.setText("labelCopyD","Source Folder:")
myUI.addItem(rrGlobal.genUIType.browseDir,"copySourceD","")
myUI.addItem(rrGlobal.genUIType.label,"labelCopyD2","")
myUI.setText("labelCopyD2","Target Folder:")
myUI.addItem(rrGlobal.genUIType.browseDir,"copyTargetD","")

myUI.addItem(rrGlobal.genUIType.spacerV,"spacerZ","")

myUI.addItem(rrGlobal.genUIType.layoutH,"btnLayout","")
myUI.addItem(rrGlobal.genUIType.closeButton,"Create Job","btnLayout")
myUI.addItem(rrGlobal.genUIType.closeButton,"Abort","btnLayout")
myUI.execute()
if (myUI.value("Abort")==1):
    del myUI
    raise rrCleanExit()
    
isDirMode=False
source=myUI.text("copySourceF");
target=myUI.text("copyTargetF");
if (len(source)==0 or len(target)==0):
    source=myUI.text("copySourceD");
    target=myUI.text("copyTargetD");
    isDirMode=True
    
copyMode= myUI.value("dropMode")
del myUI


if (len(source)==0 or len(target)==0):
    rrGlobal.writeLog(rrGlobal.logLvL.warning, "Either the source or target was not set!\nAborting.","")
    raise rrCleanExit()
    



fileBaseName=rrGlobal.rrRootPath()+"inhouse\\rrCopyFile_"
fileBaseName= fileBaseName+ datetime.datetime.now().strftime("%Y%m%d_%H%M%S")
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")


#The commandline will be written as universal OS code and then replaced per OS
batchF = rrGlobal.getCrossBatch()
batchF.osVarAdd("rrCopy","rrCopy.exe","rrCopy","rrCopy.app\Contents\MacOS\rrCopy")  
batchF.setBaseFileName(fileBaseName)

batchF.addLine("<comment> This file was automatically created by a rrSubmitter Scripted Job Plugin ")
batchF.addFlag("<rrBin><rrCopy>")
if (isDirMode):
    batchF.addFlag("-d")
if (copyMode==1):
    batchF.addFlag("-oo")
    batchF.addFlag("-os")
elif (copyMode==2):
    batchF.addFlag("-sync")
elif (copyMode==3):
    batchF.addFlag("-oa")
elif (copyMode==4):
    batchF.addFlag("-oa")
    batchF.addFlag("-or")

batchF.addFlag(source)
batchF.addFlag(target)

batchF.addEnd()
batchF.addEnd()



if (sys.platform.lower() == "win32"):
    rr.setSubmitterParameter("DefaultClientGroup=1~Windows")
    if not batchF.saveWin():
        raise Exception(batchF.fileErrorMessage())
elif (sys.platform.lower() == "darwin"):
    rr.setSubmitterParameter("DefaultClientGroup=1~OSX")
    if not batchF.saveOsx():
        raise Exception(batchF.fileErrorMessage())
else:
    rr.setSubmitterParameter("DefaultClientGroup=1~Linux")    
    if not batchF.saveLx():
        raise Exception(batchF.fileErrorMessage())



#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="rrCopy"


newJob=  rr.getNewJob()
newJob.overrideIcon=overrideIcon;
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName="<SceneFolder>\no.file"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="rrCopy"

rr.setSubmitterParameter("MaxClientsAtATime=0~5")

rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.
